
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_George = m.addVar(lb=0, name="hours_worked_by_George", vtype=GRB.CONTINUOUS)
hours_worked_by_Dale = m.addVar(lb=0, name="hours_worked_by_Dale", vtype=GRB.CONTINUOUS)

# Objective function
m.setObjective(7 * hours_worked_by_George + 7 * hours_worked_by_Dale, GRB.MINIMIZE)

# Constraints
m.addConstr(5 * hours_worked_by_George + 3 * hours_worked_by_Dale >= 14, name="paperwork_min")
m.addConstr(15 * hours_worked_by_George + 9 * hours_worked_by_Dale >= 14, name="computer_min")
m.addConstr(hours_worked_by_George - 7 * hours_worked_by_Dale >= 0, name="george_dale_constraint")
m.addConstr(5 * hours_worked_by_George + 3 * hours_worked_by_Dale <= 45, name="paperwork_max")
m.addConstr(15 * hours_worked_by_George + 9 * hours_worked_by_Dale <= 50, name="computer_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by George: {hours_worked_by_George.x}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.x}")
else:
    print("No optimal solution found.")
