
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    george_hours = model.addVar(name="george_hours", lb=0)  # Assuming hours cannot be negative
    dale_hours = model.addVar(name="dale_hours", lb=0)  # Assuming hours cannot be negative

    # Objective function: Minimize 7 * (George's hours + Dale's hours)
    model.setObjective(7 * george_hours + 7 * dale_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * george_hours + 3 * dale_hours >= 14, name="min_paperwork")
    model.addConstr(15 * george_hours + 9 * dale_hours >= 14, name="min_computer")
    model.addConstr(george_hours - 7 * dale_hours >= 0, name="george_dale_ratio")
    model.addConstr(5 * george_hours + 3 * dale_hours <= 45, name="max_paperwork")
    model.addConstr(15 * george_hours + 9 * dale_hours <= 50, name="max_computer")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"George's hours: {george_hours.varValue}")
        print(f"Dale's hours: {dale_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
