
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")

# Set objective function
m.setObjective(5 * x0 + 7 * x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13 * x0 + 20 * x1 >= 45, "min_fuel_demand")
m.addConstr(13 * x0 + 13 * x1 >= 45, "min_logistical_capacity")
m.addConstr(19 * x0 + 15 * x1 >= 41, "min_logistics_footprint")
m.addConstr(1 * x0 - 7 * x1 >= 0, "custom_constraint_1")

m.addConstr(13 * x0 + 20 * x1 <= 58, "max_fuel_demand_1")
m.addConstr(13 * x0 + 20 * x1 <= 58, "max_fuel_demand_2") # Redundant constraint
m.addConstr(13 * x0 + 13 * x1 <= 94, "max_logistical_capacity_1")
m.addConstr(13 * x0 + 13 * x1 <= 94, "max_logistical_capacity_2") # Redundant constraint
m.addConstr(19 * x0 + 15 * x1 <= 77, "max_logistics_footprint_1")
m.addConstr(19 * x0 + 15 * x1 <= 77, "max_logistics_footprint_2") # Redundant constraint


# Resource upper bounds (not explicitly mentioned as constraints in the problem description, but included from the context)
m.addConstr(13 * x0 + 20 * x1 <= 116, "fuel_upper_bound")
m.addConstr(13 * x0 + 13 * x1 <= 106, "logistical_capacity_upper_bound")
m.addConstr(19 * x0 + 15 * x1 <= 120, "logistics_footprint_upper_bound")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0:', x0.x)
    print('x1:', x1.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

