
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x1 = m.addVar(vtype=GRB.INTEGER, name="pathfinder_teams")

# Set the objective function
m.setObjective(5*x0 + 7*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13*x0 + 20*x1 >= 45, "min_fuel_demand")
m.addConstr(13*x0 + 20*x1 <= 58, "max_fuel_demand")
m.addConstr(13*x0 + 13*x1 >= 45, "min_logistical_capacity")
m.addConstr(13*x0 + 13*x1 <= 94, "max_logistical_capacity")
m.addConstr(19*x0 + 15*x1 >= 41, "min_logistics_footprint")
m.addConstr(19*x0 + 15*x1 <= 77, "max_logistics_footprint")
m.addConstr(x0 - 7*x1 >= 0, "additional_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Reconnaissance troops: {x0.x}")
    print(f"Pathfinder teams: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
