
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("troops_and_teams")

# Define the variables
R = m.addVar(name="reconnaissance_troops", vtype=GRB.INTEGER)
P = m.addVar(name="pathfinder_teams", vtype=GRB.INTEGER)

# Objective function: Maximize 5R + 7P
m.setObjective(5*R + 7*P, GRB.MAXIMIZE)

# Constraints
# Fuel demand constraints
m.addConstr(13*R + 20*P >= 45, name="min_fuel_demand")
m.addConstr(13*R + 20*P <= 58, name="max_fuel_demand")

# Logistical capacity constraints
m.addConstr(13*R + 13*P >= 45, name="min_logistical_capacity")
m.addConstr(13*R + 13*P <= 94, name="max_logistical_capacity")

# Logistics footprint constraints
m.addConstr(19*R + 15*P >= 41, name="min_logistics_footprint")
m.addConstr(19*R + 15*P <= 77, name="max_logistics_footprint")

# Additional constraint
m.addConstr(R - 7*P >= 0, name="additional_constraint")

# Solve the model
m.solve()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Reconnaissance Troops: {R.varValue}")
    print(f"Pathfinder Teams: {P.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
