
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein_bars = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
strawberries = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries")

# Set objective function
m.setObjective(2 * protein_bars + 4 * strawberries, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * protein_bars + 3 * strawberries >= 6, "sourness_min")
m.addConstr(2 * protein_bars + 14 * strawberries >= 23, "iron_min")
m.addConstr(4 * protein_bars + 12 * strawberries >= 23, "calcium_min")
m.addConstr(11 * protein_bars + 3 * strawberries >= 5, "protein_min")
m.addConstr(4 * protein_bars - 9 * strawberries >= 0, "custom_constraint")

m.addConstr(14 * protein_bars + 3 * strawberries <= 17, "sourness_max")
m.addConstr(2 * protein_bars + 14 * strawberries <= 39, "iron_max")
m.addConstr(4 * protein_bars + 12 * strawberries <= 44, "calcium_max")
m.addConstr(11 * protein_bars + 3 * strawberries <= 26, "protein_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Protein bars: {protein_bars.x}")
    print(f"Strawberries: {strawberries.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

