
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="protein_bars")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="strawberries", lb=0)

# Objective function: Maximize 2*x0 + 4*x1
m.setObjective(2*x0 + 4*x1, GRB.MAXIMIZE)

# Constraints
# Sourness index constraints
m.addConstr(14*x0 + 3*x1 >= 6, name="sourness_index_min")
m.addConstr(14*x0 + 3*x1 <= 17, name="sourness_index_max")

# Iron constraints
m.addConstr(2*x0 + 14*x1 >= 23, name="iron_min")
m.addConstr(2*x0 + 14*x1 <= 39, name="iron_max")

# Calcium constraints
m.addConstr(4*x0 + 12*x1 >= 23, name="calcium_min")
m.addConstr(4*x0 + 12*x1 <= 44, name="calcium_max")

# Protein constraints
m.addConstr(11*x0 + 3*x1 >= 5, name="protein_min")
m.addConstr(11*x0 + 3*x1 <= 26, name="protein_max")

# Additional constraint
m.addConstr(4*x0 - 9*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Protein bars: {x0.x}")
    print(f"Strawberries: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
