
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="protein_bars", vtype=gp.GRB.INTEGER)  # integer variable for protein bars
x1 = m.addVar(name="strawberries")  # continuous variable for strawberries

# Define the objective function
m.setObjective(2 * x0 + 4 * x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * x0 + 3 * x1 >= 6, name="sourness_index")
m.addConstr(2 * x0 + 14 * x1 >= 23, name="iron")
m.addConstr(4 * x0 + 12 * x1 >= 23, name="calcium")
m.addConstr(11 * x0 + 3 * x1 >= 5, name="protein")
m.addConstr(4 * x0 - 9 * x1 >= 0, name="linear_combination")
m.addConstr(14 * x0 + 3 * x1 <= 17, name="sourness_index_upper")
m.addConstr(2 * x0 + 14 * x1 <= 39, name="iron_upper")
m.addConstr(4 * x0 + 12 * x1 <= 44, name="calcium_upper")
m.addConstr(11 * x0 + 3 * x1 <= 26, name="protein_upper")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Protein bars: {x0.varValue}")
    print(f"Strawberries: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
