
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x = m.addVars(6, name=["hot dogs", "ham sandwiches", "blueberry pies", "granola bars", "cornichons", "strawberries"], lb=0)  

# Objective function
obj = 2*x[0]*x[1] + 8*x[0]*x[3] + 8*x[0]*x[4] + 3*x[0]*x[5] + 2*x[1]*x[2] + 9*x[1]*x[3] + 4*x[1]*x[4] + 9*x[2]**2 + 5*x[2]*x[5] + 6*x[3]**2 + x[3]*x[4] + 5*x[3]*x[5] + 7*x[4]**2 + 9*x[4]*x[5] + 5*x[5]**2 + 9*x[1] + 6*x[4] + 3*x[5]

# Set the objective function
m.setObjective(obj, gp.GRB.MINIMIZE)

# Calcium constraints
m.addConstr(23*x[0] + x[1] + 20*x[2] + 2*x[3] + 5*x[4] + 21*x[5] <= 244)
m.addConstr(23*x[0] + 21*x[5] >= 26)
m.addConstr(2*x[3] + 5*x[4] >= 18)
m.addConstr(20*x[2]**2 + 2*x[3]**2 >= 28)

# Healthiness constraints
m.addConstr(17*x[0] + 19*x[1] + 25*x[2] + 28*x[3] + 25*x[4] + 3*x[5] <= 354)
m.addConstr(25*x[2] + 3*x[5] >= 39)
m.addConstr(19*x[1] + 3*x[5] >= 29)
m.addConstr(28*x[3] + 25*x[4] >= 39)

# Bounds
m.addConstr(2*x[3] + 5*x[4] <= 137)
m.addConstr(19*x[1] + 3*x[5] <= 202)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    for i in range(6):
        print(f"{x[i].name} = {x[i].varValue}")
else:
    print("No optimal solution found")
