
import gurobi as gp

m = gp.Model("optimization_problem")

c = m.addVar(lb=0, name="cantaloupes", vtype=gp.GRB.INTEGER)
o = m.addVar(lb=0, name="oreos", vtype=gp.GRB.INTEGER)
a = m.addVar(lb=0, name="apple_pies", vtype=gp.GRB.INTEGER)
k = m.addVar(lb=0, name="kiwis")
r = m.addVar(lb=0, name="bowls_of_instant_ramen")
t = m.addVar(lb=0, name="rotisserie_chickens", vtype=gp.GRB.INTEGER)

obj = 6.3*c**2 + 3.48*c*o + 6.25*c*r + 4.34*c*t + 1.08*o*a + 7.63*o*k + 6.66*a**2 + 6.5*a*k + 7.97*a*t + 4.5*k**2 + 7.24*k*t + 5.51*r*t + 7.25*c + 5.43*a + 3.49*k + 8.39*r + 4.79*t

m.setObjective(obj, gp.GRB.MAXIMIZE)

# Cost constraints
m.addConstr(6*c + 9*o + 11*a + 5*k + 10*r + 9*t <= 381, name="max_cost")
m.addConstr(6*c >= 6, name="min_cantaloupes_cost")
m.addConstr(9*o >= 9, name="min_oreos_cost")
m.addConstr(11*a >= 11, name="min_apple_cost")
m.addConstr(5*k >= 5, name="min_kiwis_cost")
m.addConstr(10*r >= 10, name="min_ramen_cost")
m.addConstr(9*t >= 9, name="min_chicken_cost")

m.addConstr(9*c + 7*o + 11*a + 9*k + 2*r + 4*t <= 378, name="max_sourness")
m.addConstr(8*c + 5*o + 8*a + 4*k + 6*r + 11*t <= 249, name="max_carbohydrates")
m.addConstr(8*c + 9*o + 7*a + 11*k + 7*r + 3*t <= 168, name="max_fat")

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cantaloupes: ", c.varValue)
    print("Oreos: ", o.varValue)
    print("Apple pies: ", a.varValue)
    print("Kiwis: ", k.varValue)
    print("Bowls of instant ramen: ", r.varValue)
    print("Rotisserie chickens: ", t.varValue)
else:
    print("The model is infeasible or unbounded.")
