
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_sourness")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")

# Set objective function
m.setObjective(4.58 * oranges + 4.28 * cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * oranges + 18 * cereal >= 22, "sourness_min")
m.addConstr(-3 * oranges + 3 * cereal >= 0, "orange_cereal_ratio")
m.addConstr(20 * oranges + 18 * cereal <= 33, "sourness_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Oranges: {oranges.x}")
    print(f"  Bowls of Cereal: {cereal.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

