
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
oranges = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")
bowls_of_cereal = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Set the objective function
m.setObjective(4.58 * oranges + 4.28 * bowls_of_cereal, GRB.MINIMIZE)

# Add constraints
m.addConstr(20 * oranges + 18 * bowls_of_cereal >= 22, "Total_Sourness_Min")
m.addConstr(oranges <= bowls_of_cereal, "Oranges_vs_Bowls")
m.addConstr(20 * oranges + 18 * bowls_of_cereal <= 33, "Total_Sourness_Max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oranges: {oranges.x}")
    print(f"Bowls of Cereal: {bowls_of_cereal.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
