
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    oranges = model.addVar(name="oranges", lb=0)  # Lower bound is 0, assuming no negative values
    bowls_of_cereal = model.addVar(name="bowls_of_cereal", lb=0)  # Lower bound is 0

    # Objective function
    model.setObjective(4.58 * oranges + 4.28 * bowls_of_cereal, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * oranges + 18 * bowls_of_cereal >= 22, name="sourness_index_min")
    model.addConstr(20 * oranges + 18 * bowls_of_cereal <= 33, name="sourness_index_max")
    model.addConstr(-3 * oranges + 3 * bowls_of_cereal >= 0, name="linear_constraint")

    # Optimize
    model.optimize()

    # Output solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bowls of Cereal: {bowls_of_cereal.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
