
from gurobipy import *

# Create a model
m = Model("Food Optimization")

# Define variables - since non-integer amounts are allowed for all items, we use continuous variables.
O = m.addVar(vtype=GRB.CONTINUOUS, name="oreos")
G = m.addVar(vtype=GRB.CONTINUOUS, name="green_beans")
P = m.addVar(vtype=GRB.CONTINUOUS, name="potatoes")
C = m.addVar(vtype=GRB.CONTINUOUS, name="cherry_pies")
R = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
RC = m.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Objective function: Maximize the total value (example coefficients used)
m.setObjective(2*O + 3*G + P + C + R + RC, GRB.MAXIMIZE)

# Constraints based on given conditions
# Protein constraints (assuming 1 unit of protein per item for simplicity)
m.addConstr(G + P >= 11, "Green beans and potatoes constraint")
m.addConstr(O + G + RC >= 19, "Oreos, green beans, and rotisserie chickens constraint")

# Tastiness rating constraints
m.addConstr(9*G + 6*C >= 13, "Green beans and cherry pies tastiness")
m.addConstr(5*P + 20*RC >= 19, "Potatoes and rotisserie chickens tastiness")

# Other constraints
m.addConstr(10*G - 3*C >= 0, "Green beans and cherry pies quantity constraint")
m.addConstr(2*O - 10*C - 5*RC >= 0, "Oreos, cherry pies, and rotisserie chickens quantity constraint")

# Protein upper bounds
m.addConstr(G + C <= 126, "Green beans and cherry pies protein limit")
m.addConstr(G + RC <= 83, "Green beans and rotisserie chickens protein limit")
m.addConstr(R + RC <= 112, "Ravioli and rotisserie chickens protein limit")

# Tastiness upper bounds
m.addConstr(5*P + 14*R <= 85, "Potatoes and ravioli tastiness limit")
m.addConstr(9*G + 14*R <= 26, "Green beans and ravioli tastiness limit")

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.VarName}: {v.X}")
