
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
apples = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="apples")
hamburgers = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="hamburgers")
pasta = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="bowls_of_pasta")
milkshakes = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="milkshakes")
granola_bars = m.addVar(lb=0, type=gp.GRB.CONTINUOUS, name="granola_bars")

# Set objective function
m.setObjective(5*apples**2 + 7*apples*hamburgers + 9*apples*pasta + 7*apples*milkshakes + 9*apples*granola_bars + 8*hamburgers**2 + 2*hamburgers*pasta + 5*hamburgers*milkshakes + 4*hamburgers*granola_bars + 6*pasta**2 + 5*pasta*milkshakes + 4*pasta*granola_bars + 7*milkshakes**2 + 3*milkshakes*granola_bars + 1*granola_bars**2 + 1*apples + 6*hamburgers + 1*pasta + 5*milkshakes + 8*granola_bars, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*apples + 8*hamburgers + 4*pasta + 5*milkshakes + 12*granola_bars <= 112, "calcium_limit")
m.addConstr(6*apples + 14*hamburgers + 6*pasta + 11*milkshakes + 13*granola_bars <= 157, "cost_limit")
m.addConstr(3*apples + 3*hamburgers + 2*pasta + 11*milkshakes + 1*granola_bars <= 242, "umami_limit")

m.addConstr(5*milkshakes**2 + 1*granola_bars**2 >= 14, "calcium_constraint1")
m.addConstr(4*pasta + 12*granola_bars >= 7, "calcium_constraint2")
m.addConstr(8*hamburgers + 12*granola_bars >= 10, "calcium_constraint3")
m.addConstr(8*apples + 4*pasta >= 17, "calcium_constraint4")

m.addConstr(6*apples**2 + 6*pasta**2 + 13*granola_bars**2 >= 30, "cost_constraint1")
m.addConstr(6*apples**2 + 6*pasta**2 + 11*milkshakes**2 >= 30, "cost_constraint2")
m.addConstr(6*apples + 11*milkshakes + 13*granola_bars >= 30, "cost_constraint3")
m.addConstr(6*apples + 14*hamburgers + 13*granola_bars >= 30, "cost_constraint4")
m.addConstr(6*apples + 6*pasta + 13*granola_bars >= 24, "cost_constraint5")
m.addConstr(6*apples + 6*pasta + 11*milkshakes >= 24, "cost_constraint6")
m.addConstr(6*apples + 11*milkshakes + 13*granola_bars >= 24, "cost_constraint7")
m.addConstr(6*apples + 14*hamburgers + 13*granola_bars >= 24, "cost_constraint8")
m.addConstr(6*apples + 6*pasta + 13*granola_bars >= 29, "cost_constraint9")
m.addConstr(6*apples + 6*pasta + 11*milkshakes >= 29, "cost_constraint10")
m.addConstr(6*apples**2 + 11*milkshakes**2 + 13*granola_bars**2 >= 29, "cost_constraint11")
m.addConstr(6*apples**2 + 14*hamburgers**2 + 13*granola_bars**2 >= 29, "cost_constraint12")
m.addConstr(6*apples**2 + 6*pasta**2 + 13*granola_bars**2 >= 23, "cost_constraint13")
m.addConstr(6*apples**2 + 6*pasta**2 + 11*milkshakes**2 >= 23, "cost_constraint14")
m.addConstr(6*apples**2 + 11*milkshakes**2 + 13*granola_bars**2 >= 23, "cost_constraint15")
m.addConstr(6*apples**2 + 14*hamburgers**2 + 13*granola_bars**2 >= 23, "cost_constraint16")


m.addConstr(3*hamburgers + 1*granola_bars >= 43, "umami_constraint1")
m.addConstr(8*apples + 4*pasta <= 98, "calcium_constraint5")
m.addConstr(8*apples + 5*milkshakes <= 71, "calcium_constraint6")
m.addConstr(8*hamburgers + 12*granola_bars <= 30, "calcium_constraint7")
m.addConstr(4*pasta + 5*milkshakes + 12*granola_bars <= 87, "calcium_constraint8")
m.addConstr(8*apples + 4*pasta + 5*milkshakes <= 109, "calcium_constraint9")
m.addConstr(8*hamburgers + 5*milkshakes + 12*granola_bars <= 85, "calcium_constraint10")
m.addConstr(8*hamburgers + 4*pasta + 12*granola_bars <= 59, "calcium_constraint11")
m.addConstr(8*hamburgers**2 + 4*pasta**2 + 5*milkshakes**2 <= 35, "calcium_constraint12")
m.addConstr(8*apples**2 + 8*hamburgers**2 + 5*milkshakes**2 <= 52, "calcium_constraint13")
m.addConstr(8*apples + 8*hamburgers + 4*pasta <= 86, "calcium_constraint14")
m.addConstr(8*apples**2 + 4*pasta**2 + 12*granola_bars**2 <= 42, "calcium_constraint15")
m.addConstr(8*apples + 8*hamburgers + 4*pasta + 5*milkshakes + 12*granola_bars <= 42, "calcium_constraint16")

m.addConstr(6*pasta + 11*milkshakes <= 70, "cost_constraint17")
m.addConstr(6*apples**2 + 6*pasta**2 <= 102, "cost_constraint18")
m.addConstr(6*apples + 14*hamburgers + 6*pasta <= 134, "cost_constraint19")
m.addConstr(14*hamburgers**2 + 6*pasta**2 + 13*granola_bars**2 <= 123, "cost_constraint20")
m.addConstr(14*hamburgers + 6*pasta + 11*milkshakes <= 82, "cost_constraint21")
m.addConstr(6*apples + 14*hamburgers + 6*pasta + 11*milkshakes + 13*granola_bars <= 82, "cost_constraint22")

m.addConstr(3*apples + 3*hamburgers <= 62, "umami_constraint2")
m.addConstr(3*apples + 11*milkshakes <= 139, "umami_constraint3")
m.addConstr(2*pasta + 1*granola_bars <= 132, "umami_constraint4")
m.addConstr(3*hamburgers**2 + 2*pasta**2 <= 205, "umami_constraint5")
m.addConstr(3*apples + 1*granola_bars <= 57, "umami_constraint6")
m.addConstr(3*apples + 2*pasta <= 105, "umami_constraint7")
m.addConstr(3*hamburgers + 2*pasta + 1*granola_bars <= 156, "umami_constraint8")
m.addConstr(3*apples + 3*hamburgers + 2*pasta + 11*milkshakes + 1*granola_bars <= 156, "umami_constraint9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
