
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")

# Set objective function
m.setObjective(8.66 * bobby_hours + 6.28 * hank_hours + 1.06 * jean_hours + 4.68 * laura_hours, gp.GRB.MINIMIZE)

# Add constraints

# Individual attribute constraints (these are redundant as they are already defined in the problem data, but included for completeness)
# m.addConstr(2 * bobby_hours == 2 * bobby_hours)  # Bobby's likelihood to quit
# m.addConstr(13 * bobby_hours == 13 * bobby_hours) # Bobby's productivity
# m.addConstr(5 * bobby_hours == 5 * bobby_hours)  # Bobby's paperwork
# m.addConstr(13 * hank_hours == 13 * hank_hours)  # Hank's likelihood to quit
# m.addConstr(4 * hank_hours == 4 * hank_hours) # Hank's productivity
# m.addConstr(10 * hank_hours == 10 * hank_hours) # Hank's paperwork
# m.addConstr(9 * jean_hours == 9 * jean_hours)  # Jean's likelihood to quit
# m.addConstr(5 * jean_hours == 5 * jean_hours) # Jean's productivity
# m.addConstr(10 * jean_hours == 10 * jean_hours) # Jean's paperwork
# m.addConstr(1 * laura_hours == 1 * laura_hours)  # Laura's likelihood to quit
# m.addConstr(1 * laura_hours == 1 * laura_hours) # Laura's productivity
# m.addConstr(12 * laura_hours == 12 * laura_hours) # Laura's paperwork


# Combined attribute constraints
m.addConstr(13 * hank_hours + 9 * jean_hours + 1 * laura_hours >= 13)
m.addConstr(2 * bobby_hours + 13 * hank_hours + 9 * jean_hours + 1 * laura_hours >= 13)
m.addConstr(13 * bobby_hours + 5 * jean_hours >= 28)
m.addConstr(4 * hank_hours + 1 * laura_hours >= 21)
m.addConstr(5 * jean_hours + 1 * laura_hours >= 20)
m.addConstr(13 * bobby_hours + 4 * hank_hours >= 28)
m.addConstr(4 * hank_hours + 5 * jean_hours + 1 * laura_hours >= 23)
m.addConstr(13 * bobby_hours + 4 * hank_hours + 5 * jean_hours + 1 * laura_hours >= 23)
m.addConstr(10 * jean_hours + 12 * laura_hours >= 17)
m.addConstr(5 * bobby_hours + 10 * jean_hours >= 15)
m.addConstr(5 * bobby_hours + 10 * hank_hours + 10 * jean_hours + 12 * laura_hours >= 15)
m.addConstr(4 * hank_hours - 2 * jean_hours >= 0)
m.addConstr(2 * bobby_hours + 9 * jean_hours <= 51)
m.addConstr(4 * hank_hours + 5 * jean_hours <= 61)
m.addConstr(5 * jean_hours + 1 * laura_hours <= 98)
m.addConstr(13 * bobby_hours + 5 * jean_hours <= 64)
m.addConstr(13 * bobby_hours + 4 * hank_hours + 1 * laura_hours <= 77)
m.addConstr(4 * hank_hours + 5 * jean_hours + 1 * laura_hours <= 91)
m.addConstr(5 * bobby_hours + 12 * laura_hours <= 81)
m.addConstr(10 * hank_hours + 10 * jean_hours <= 74)
m.addConstr(10 * hank_hours + 12 * laura_hours <= 60)
m.addConstr(10 * jean_hours + 12 * laura_hours <= 77)
m.addConstr(5 * bobby_hours + 10 * hank_hours + 12 * laura_hours <= 70)
m.addConstr(5 * bobby_hours + 10 * hank_hours + 10 * jean_hours <= 43)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Bobby hours:', bobby_hours.x)
    print('Hank hours:', hank_hours.x)
    print('Jean hours:', jean_hours.x)
    print('Laura hours:', laura_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
