
import gurobi as gp

# Create a new model
m = gp.Model()

# Define variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Bobby
x1 = m.addVar(name="x1", lb=0)  # hours worked by Hank
x2 = m.addVar(name="x2", lb=0)  # hours worked by Jean
x3 = m.addVar(name="x3", lb=0)  # hours worked by Laura

# Objective function
m.setObjective(8.66*x0 + 6.28*x1 + 1.06*x2 + 4.68*x3, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2*x0 == 2)
m.addConstr(13*x0 == 13)
m.addConstr(5*x0 == 5)
m.addConstr(13*x1 == 13)
m.addConstr(4*x1 == 4)
m.addConstr(10*x1 == 10)
m.addConstr(9*x2 == 9)
m.addConstr(5*x2 == 5)
m.addConstr(10*x2 == 10)
m.addConstr(x3 == 1)
m.addConstr(x3 == 1)
m.addConstr(12*x3 == 12)
m.addConstr(13*x1 + 9*x2 + x3 >= 13)
m.addConstr(2*x0 + 13*x1 + 9*x2 + x3 >= 13)
m.addConstr(13*x0 + 5*x2 >= 28)
m.addConstr(4*x1 + x3 >= 21)
m.addConstr(5*x2 + x3 >= 20)
m.addConstr(13*x0 + 4*x1 >= 28)
m.addConstr(4*x1 + 5*x2 + x3 >= 23)
m.addConstr(13*x0 + 4*x1 + 5*x2 + x3 >= 23)
m.addConstr(10*x2 + 12*x3 >= 17)
m.addConstr(5*x0 + 10*x2 >= 15)
m.addConstr(5*x0 + 10*x1 + 10*x2 + 12*x3 >= 15)
m.addConstr(4*x1 - 2*x2 >= 0)
m.addConstr(2*x0 + 9*x2 <= 51)
m.addConstr(4*x1 + 5*x2 <= 61)
m.addConstr(5*x2 + x3 <= 98)
m.addConstr(13*x0 + 5*x2 <= 64)
m.addConstr(13*x0 + 4*x1 + x3 <= 77)
m.addConstr(4*x1 + 5*x2 + x3 <= 91)
m.addConstr(5*x0 + 12*x3 <= 81)
m.addConstr(10*x1 + 10*x2 <= 74)
m.addConstr(10*x1 + 12*x3 <= 60)
m.addConstr(10*x2 + 12*x3 <= 77)
m.addConstr(5*x0 + 10*x1 + 12*x3 <= 70)
m.addConstr(5*x0 + 10*x1 + 10*x2 <= 43)

# Solve the model
try:
    m.optimize()
    if m.status == gp.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective value:", m.objVal)
        print("Hours worked by Bobby:", x0.x)
        print("Hours worked by Hank:", x1.x)
        print("Hours worked by Jean:", x2.x)
        print("Hours worked by Laura:", x3.x)
    elif m.status == gp.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status:", m.status)
except gp.GRB.Error as e:
    print("Gurobi error:", e)
