
from gurobipy import Model, GRB

# Create a new model
m = Model("employee_scheduling")

# Create variables
laura_hours = m.addVar(vtype=GRB.INTEGER, name="laura_hours")
mary_hours = m.addVar(vtype=GRB.CONTINUOUS, name="mary_hours")
ringo_hours = m.addVar(vtype=GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
m.setObjective(8 * laura_hours + 6 * mary_hours + 5 * ringo_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * laura_hours + 3 * ringo_hours >= 12, "c1")
m.addConstr(4 * laura_hours + 11 * mary_hours <= 36, "c2")
m.addConstr(11 * mary_hours + 3 * ringo_hours <= 47, "c3")
m.addConstr(4 * laura_hours + 11 * mary_hours + 3 * ringo_hours <= 47, "c4")
m.addConstr(6 * mary_hours + 8 * ringo_hours <= 48, "c5")
m.addConstr(3 * laura_hours + 8 * ringo_hours <= 60, "c6")
m.addConstr(3 * laura_hours + 6 * mary_hours + 8 * ringo_hours <= 25, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

