
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    L = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
    M = model.addVar(name="hours_worked_by_Mary")
    R = model.addVar(name="hours_worked_by_Ringo")

    # Objective function: Maximize 8L + 6M + 5R
    model.setObjective(8*L + 6*M + 5*R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*L + 3*R >= 12, name="likelihood_quit_LR")
    model.addConstr(4*L + 11*M <= 36, name="likelihood_quit_LM")
    model.addConstr(11*M + 3*R <= 47, name="likelihood_quit_MR")
    model.addConstr(4*L + 11*M + 3*R <= 47, name="likelihood_quit_LMR")
    model.addConstr(6*M + 8*R <= 48, name="dollar_cost_MR")
    model.addConstr(3*L + 8*R <= 60, name="dollar_cost_LR")
    model.addConstr(3*L + 6*M + 8*R <= 25, name="dollar_cost_LMR")

    # Non-negativity constraints (Implicit in Gurobi for continuous and integer variables)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Laura: {L.varValue}")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by Ringo: {R.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
