
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
mary_hours = m.addVar(name="mary_hours")
george_hours = m.addVar(name="george_hours")
bill_hours = m.addVar(name="bill_hours")

# Set objective function
m.setObjective(7.08 * mary_hours + 2.43 * george_hours + 4.45 * bill_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * mary_hours + 12 * bill_hours >= 38, "computer_competence_1")
m.addConstr(15 * mary_hours + 4 * george_hours + 12 * bill_hours >= 53, "computer_competence_2")
m.addConstr(6 * mary_hours + 4 * bill_hours >= 28, "organization_score_1")
m.addConstr(6 * mary_hours + 8 * george_hours + 4 * bill_hours >= 29, "organization_score_2")
m.addConstr(4 * george_hours + 12 * bill_hours <= 156, "computer_competence_3")
m.addConstr(15 * mary_hours + 4 * george_hours + 12 * bill_hours <= 156, "computer_competence_4")
m.addConstr(2 * mary_hours + 10 * bill_hours <= 66, "work_quality_1")
m.addConstr(2 * mary_hours + 6 * george_hours + 10 * bill_hours <= 92, "work_quality_2")
m.addConstr(7 * mary_hours + 6 * bill_hours <= 100, "paperwork_competence_1")
m.addConstr(7 * mary_hours + 12 * george_hours + 6 * bill_hours <= 100, "paperwork_competence_2")
m.addConstr(8 * george_hours + 4 * bill_hours <= 33, "organization_score_3")
m.addConstr(6 * mary_hours + 8 * george_hours + 4 * bill_hours <= 33, "organization_score_4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f"Mary's hours: {mary_hours.x}")
    print(f"George's hours: {george_hours.x}")
    print(f"Bill's hours: {bill_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f"Optimization ended with status {m.status}")

