
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
M = m.addVar(lb=0, name="hours_worked_by_Mary")
G = m.addVar(lb=0, name="hours_worked_by_George")
B = m.addVar(lb=0, name="hours_worked_by_Bill")

# Objective function: Maximize
m.setObjective(7.08*M + 2.43*G + 4.45*B, GRB.MAXIMIZE)

# Constraints
m.addConstr(15*M + 12*B >= 38, "ComputerCompetence_MaryBill")
m.addConstr(15*M + 4*G + 12*B >= 53, "ComputerCompetence_All")
m.addConstr(6*M + 4*B >= 28, "OrganizationScore_MaryBill")
m.addConstr(6*M + 8*G + 4*B >= 29, "OrganizationScore_All")
m.addConstr(4*G + 12*B <= 156, "ComputerCompetence_GeorgeBill_Max")
m.addConstr(15*M + 4*G + 12*B <= 156, "ComputerCompetence_All_Max")
m.addConstr(2*M + 10*B <= 66, "WorkQuality_MaryBill_Max")
m.addConstr(2*M + 6*G + 10*B <= 92, "WorkQuality_All_Max")
m.addConstr(7*M + 6*B <= 100, "PaperworkCompetence_MaryBill_Max")
m.addConstr(7*M + 12*G + 6*B <= 100, "PaperworkCompetence_All_Max")
m.addConstr(8*G + 4*B <= 33, "OrganizationScore_GeorgeBill_Max")
m.addConstr(6*M + 8*G + 4*B <= 33, "OrganizationScore_All_Max")

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.VarName}: {v.X}")

print("Obj:", m.ObjVal)
