
import gurobi

def optimize_hours():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(lb=0, name="Mary_hours")  # hours worked by Mary
    G = model.addVar(lb=0, name="George_hours")  # hours worked by George
    B = model.addVar(lb=0, name="Bill_hours")  # hours worked by Bill

    # Objective function
    model.setObjective(7.08 * M + 2.43 * G + 4.45 * B, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual ratings are implicitly handled as they are constants
    # Combined ratings constraints
    model.addConstr(15 * M + 12 * B >= 38, name="comp_M_B")
    model.addConstr(15 * M + 4 * G + 12 * B >= 53, name="comp_M_G_B")
    model.addConstr(6 * M + 4 * B >= 28, name="org_M_B")
    model.addConstr(6 * M + 8 * G + 4 * B >= 29, name="org_M_G_B")
    model.addConstr(4 * G + 12 * B <= 156, name="comp_G_B")
    model.addConstr(15 * M + 4 * G + 12 * B <= 156, name="comp_M_G_B上限")
    model.addConstr(2 * M + 10 * B <= 66, name="work_M_B")
    model.addConstr(2 * M + 6 * G + 10 * B <= 92, name="work_M_G_B")
    model.addConstr(7 * M + 6 * B <= 100, name="paper_M_B")
    model.addConstr(7 * M + 12 * G + 6 * B <= 100, name="paper_M_G_B")
    model.addConstr(8 * G + 4 * B <= 33, name="org_G_B")
    model.addConstr(6 * M + 8 * G + 4 * B <= 33, name="org_M_G_B上限")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Mary: {M.varValue}")
        print(f"Hours worked by George: {G.varValue}")
        print(f"Hours worked by Bill: {B.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_hours()
