
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
bill_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Bill_Hours")
mary_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Mary_Hours")
ringo_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Ringo_Hours")
jean_hours = model.addVar(vtype=gp.GRB.INTEGER, name="Jean_Hours")

# Set objective function
model.setObjective(7.97 * bill_hours + 6.79 * mary_hours + 5.42 * ringo_hours + 2.69 * jean_hours, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * bill_hours + 9 * ringo_hours >= 26, "c1")
model.addConstr(6 * bill_hours + 10 * jean_hours >= 30, "c2")
model.addConstr(8 * mary_hours + 9 * ringo_hours >= 30, "c3")
model.addConstr(6 * bill_hours + 8 * mary_hours >= 37, "c4")
model.addConstr(9 * ringo_hours + 10 * jean_hours >= 25, "c5")
model.addConstr(6 * bill_hours + 8 * mary_hours + 9 * ringo_hours >= 31, "c6")
model.addConstr(6 * bill_hours + 8 * mary_hours + 9 * ringo_hours + 10 * jean_hours >= 31, "c7")
model.addConstr(3 * mary_hours + 10 * jean_hours >= 17, "c8")
model.addConstr(3 * mary_hours + 4 * ringo_hours >= 33, "c9")
model.addConstr(8 * bill_hours + 10 * jean_hours >= 12, "c10")
model.addConstr(8 * bill_hours + 4 * ringo_hours >= 29, "c11")
model.addConstr(8 * bill_hours + 3 * mary_hours + 4 * ringo_hours + 10 * jean_hours >= 29, "c12")
model.addConstr(8 * bill_hours + 3 * mary_hours <= 83, "c13")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('\nCost: %g' % model.objVal)
    print('\nSolution:')
    print('Bill Hours: %g' % bill_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
    print('Ringo Hours: %g' % ringo_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
elif model.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

