
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
Bill_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Bill")
Mary_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
Ringo_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
Jean_hours = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Define the objective function
m.setObjective(7.97 * Bill_hours + 6.79 * Mary_hours + 5.42 * Ringo_hours + 2.69 * Jean_hours, GRB.MINIMIZE)

# Add constraints based on given conditions

# Minimum combined computer competence ratings
m.addConstr(Bill_hours * 6 + Ringo_hours * 9 >= 26)
m.addConstr(Bill_hours * 6 + Jean_hours * 10 >= 30)
m.addConstr(Mary_hours * 8 + Ringo_hours * 9 >= 30)
m.addConstr(Bill_hours * 6 + Mary_hours * 8 >= 37)
m.addConstr(Ringo_hours * 9 + Jean_hours * 10 >= 25)
m.addConstr(Bill_hours * 6 + Mary_hours * 8 + Ringo_hours * 9 >= 31)
m.addConstr(Bill_hours * 6 + Mary_hours * 8 + Ringo_hours * 9 + Jean_hours * 10 >= 31)

# Minimum combined paperwork competence ratings
m.addConstr(Mary_hours * 3 + Jean_hours * 10 >= 17)
m.addConstr(Mary_hours * 3 + Ringo_hours * 4 >= 33)
m.addConstr(Bill_hours * 8 + Jean_hours * 10 >= 12)
m.addConstr(Bill_hours * 8 + Ringo_hours * 4 >= 29)
m.addConstr(Bill_hours * 8 + Mary_hours * 3 + Ringo_hours * 4 + Jean_hours * 10 >= 29)

# Maximum combined paperwork competence rating for Bill and Mary
m.addConstr(Bill_hours * 8 + Mary_hours * 3 <= 83)

# Optimize the model
m.optimize()

# Print results if an optimal solution is found, otherwise print a message indicating no optimal solution exists.
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution exists.")
