
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="hours_worked_by_Bill", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Mary", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="hours_worked_by_Ringo", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="hours_worked_by_Jean", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(7.97 * x0 + 6.79 * x1 + 5.42 * x2 + 2.69 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x0 + 9 * x2 >= 26)
    model.addConstr(6 * x0 + 10 * x3 >= 30)
    model.addConstr(8 * x1 + 9 * x2 >= 30)
    model.addConstr(6 * x0 + 8 * x1 >= 37)
    model.addConstr(9 * x2 + 10 * x3 >= 25)
    model.addConstr(6 * x0 + 8 * x1 + 9 * x2 >= 31)
    model.addConstr(6 * x0 + 8 * x1 + 9 * x2 + 10 * x3 >= 31)
    model.addConstr(3 * x1 + 10 * x3 >= 17)
    model.addConstr(3 * x1 + 4 * x2 >= 33)
    model.addConstr(8 * x0 + 10 * x3 >= 12)
    model.addConstr(8 * x0 + 4 * x2 >= 29)
    model.addConstr(8 * x0 + 3 * x1 + 4 * x2 + 10 * x3 >= 29)
    model.addConstr(8 * x0 + 3 * x1 <= 83)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x0.varValue}")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Hours worked by Jean: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
