
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
vitamin_b12 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_b12")
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")

# Set objective function
m.setObjective(5 * magnesium**2 + 5 * vitamin_b12 * protein + 7 * vitamin_b12 * vitamin_e + 8 * protein * vitamin_e + 8 * vitamin_e**2 + 6 * vitamin_b12 + 5 * protein + 5 * vitamin_e, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14 * protein + 6 * vitamin_e >= 28, "c0")
m.addConstr(4 * magnesium**2 + 9 * vitamin_b12**2 >= 42, "c1")
m.addConstr(9 * vitamin_b12**2 + 14 * protein**2 >= 62, "c2")
m.addConstr(4 * magnesium + 9 * vitamin_b12 + 6 * vitamin_e >= 59, "c3")
m.addConstr(4 * magnesium + 14 * protein + 6 * vitamin_e >= 59, "c4")
m.addConstr(4 * magnesium**2 + 9 * vitamin_b12**2 + 6 * vitamin_e**2 >= 46, "c5")
m.addConstr(4 * magnesium + 14 * protein + 6 * vitamin_e >= 46, "c6")
m.addConstr(5 * protein + 4 * vitamin_e <= 33, "c7")
m.addConstr(2 * vitamin_b12 + 5 * protein <= 60, "c8")
m.addConstr(magnesium**2 + 5 * protein**2 <= 52, "c9")
m.addConstr(2 * vitamin_b12**2 + 4 * vitamin_e**2 <= 42, "c10")
m.addConstr(magnesium + 2 * vitamin_b12 + 5 * protein + 4 * vitamin_e <= 42, "c11")
m.addConstr(4 * magnesium**2 + 9 * vitamin_b12**2 <= 141, "c12")
m.addConstr(9 * vitamin_b12 + 14 * protein <= 112, "c13")
m.addConstr(14 * protein + 6 * vitamin_e <= 155, "c14")
m.addConstr(4 * magnesium**2 + 14 * protein**2 <= 69, "c15")
m.addConstr(9 * vitamin_b12 + 6 * vitamin_e <= 92, "c16")
m.addConstr(4 * magnesium + 9 * vitamin_b12 + 14 * protein + 6 * vitamin_e <= 92, "c17")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

