
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of magnesium", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B12", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams of protein", vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin E", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(5*x0**2 + 5*x1*x2 + 7*x1*x3 + 8*x2*x3 + 8*x3**2 + 6*x1 + 5*x2 + 5*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 <= 63)
    model.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 >= 248)
    model.addConstr(x2 + x3 >= 2)
    model.addConstr(16*x0 + 81*x1 >= 42)
    model.addConstr(81*x1 + 196*x2 >= 62)
    model.addConstr(4*x0 + 9*x1 + 6*x3 >= 59)
    model.addConstr(4*x0 + 14*x2 + 6*x3 >= 59)
    model.addConstr(16*x0 + 81*x1 + 36*x3 >= 46)
    model.addConstr(4*x0 + 14*x2 + 6*x3 >= 46)
    model.addConstr(5*x2 + 4*x3 <= 33)
    model.addConstr(2*x1 + 5*x2 <= 60)
    model.addConstr(x0 + 25*x2 <= 52)
    model.addConstr(4*x1 + 16*x3 <= 42)
    model.addConstr(x0 + 2*x1 + 5*x2 + 4*x3 <= 42)
    model.addConstr(16*x0 + 81*x1 <= 141)
    model.addConstr(9*x1 + 14*x2 <= 112)
    model.addConstr(14*x2 + 6*x3 <= 155)
    model.addConstr(16*x0 + 196*x2 <= 69)
    model.addConstr(9*x1 + 6*x3 <= 92)
    model.addConstr(4*x0 + 9*x1 + 14*x2 + 6*x3 <= 92)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("milligrams of magnesium: ", x0.varValue)
        print("milligrams of vitamin B12: ", x1.varValue)
        print("grams of protein: ", x2.varValue)
        print("milligrams of vitamin E: ", x3.varValue)
    else:
        print("No solution found")

optimize()
