
from gurobipy import Model, GRB

# Create a new model
model = Model("food_optimization")

# Create variables
apple_pies = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
green_beans = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_beans")
granola_bars = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
oreos = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Set objective function
model.setObjective(2 * apple_pies + 9 * green_beans + 2 * granola_bars + 4 * oreos, GRB.MAXIMIZE)

# Add constraints based on resource usage
model.addConstr(5 * apple_pies + 9 * green_beans + 4 * granola_bars + 4 * oreos <= 76, "iron_limit")  # r0: iron
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars + 6 * oreos <= 81, "fat_limit")   # r1: fat
model.addConstr(9 * apple_pies + 6 * green_beans + 3 * granola_bars + 7 * oreos <= 83, "calcium_limit") # r2: calcium

# Additional constraints
model.addConstr(4 * granola_bars + 4 * oreos >= 7, "iron_granola_oreos")
model.addConstr(9 * green_beans + 4 * granola_bars >= 6, "iron_greenbeans_granola")
model.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 14, "fat_applepies_granola_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 14, "fat_applepies_greenbeans_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 14, "fat_applepies_greenbeans_granola")
model.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 13, "fat2_applepies_granola_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 13, "fat2_applepies_greenbeans_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 13, "fat2_applepies_greenbeans_granola")
model.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 11, "fat3_applepies_granola_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 11, "fat3_applepies_greenbeans_oreos")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 11, "fat3_applepies_greenbeans_granola")
model.addConstr(9 * apple_pies + 7 * oreos >= 8, "calcium_applepies_oreos")
model.addConstr(6 * green_beans + 7 * oreos >= 17, "calcium_greenbeans_oreos")
model.addConstr(6 * green_beans + 3 * granola_bars >= 10, "calcium_greenbeans_granola")
model.addConstr(9 * apple_pies + 3 * granola_bars >= 16, "calcium_applepies_granola")
model.addConstr(6 * green_beans - 5 * granola_bars >= 0, "greenbeans_granola_relation")
model.addConstr(4 * granola_bars + 4 * oreos <= 20, "iron_granola_oreos_upper")
model.addConstr(5 * apple_pies + 9 * green_beans <= 36, "iron_applepies_greenbeans_upper")
model.addConstr(5 * apple_pies + 4 * oreos <= 63, "iron_applepies_oreos_upper")
model.addConstr(9 * green_beans + 4 * oreos <= 35, "iron_greenbeans_oreos_upper")
model.addConstr(5 * apple_pies + 4 * granola_bars <= 57, "iron_applepies_granola_upper")
model.addConstr(5 * apple_pies + 4 * granola_bars + 4 * oreos <= 64, "iron_total_upper1")
model.addConstr(5 * apple_pies + 9 * green_beans + 4 * granola_bars + 4 * oreos <= 64, "iron_total_upper2")
model.addConstr(6 * granola_bars + 6 * oreos <= 61, "fat_granola_oreos_upper")
model.addConstr(4 * green_beans + 6 * oreos <= 65, "fat_greenbeans_oreos_upper")
model.addConstr(5 * apple_pies + 6 * oreos <= 75, "fat_applepies_oreos_upper")
model.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars + 6 * oreos <= 75, "fat_total_upper")
model.addConstr(9 * apple_pies + 3 * granola_bars <= 37, "calcium_applepies_granola_upper")
model.addConstr(3 * granola_bars + 7 * oreos <= 23, "calcium_granola_oreos_upper")
model.addConstr(9 * apple_pies + 6 * green_beans <= 71, "calcium_applepies_greenbeans_upper")
model.addConstr(6 * green_beans + 7 * oreos <= 33, "calcium_greenbeans_oreos_upper")
model.addConstr(6 * green_beans + 3 * granola_bars <= 78, "calcium_greenbeans_granola_upper")
model.addConstr(9 * apple_pies + 6 * green_beans + 3 * granola_bars + 7 * oreos <= 78, "calcium_total_upper")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

