
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (allowed to be non-integer)
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="green_beans")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola_bars")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oreos")

# Objective function
m.setObjective(2*x0 + 9*x1 + 2*x2 + 4*x3, GRB.MAXIMIZE)

# Constraints based on the problem description
# Iron constraints
m.addConstr(5*x0 + 9*x1 + 4*x2 + 4*x3 <= 76) # Total iron constraint

# Specific iron constraints from certain combinations of foods
m.addConstr(4*x2 + 4*x3 >= 7) # At least 7mg iron from granola bars and oreos
m.addConstr(9*x1 + 4*x2 >= 6) # At least 6mg iron from green beans plus granola bars

# Fat constraints
m.addConstr(5*x0 + 4*x1 + 6*x2 + 6*x3 <= 81) # Total fat constraint
m.addConstr(5*x0 + 6*x2 + 6*x3 >= 14) # At least 14g fat from apple pies, granola bars, and oreos
m.addConstr(5*x0 + 4*x1 + 6*x3 >= 14) # At least 14g fat from apple pies, green beans, and oreos
m.addConstr(5*x0 + 4*x1 + 6*x2 >= 14) # At least 14g fat from apple pies, green beans, and granola bars

# Calcium constraints
m.addConstr(9*x0 + 6*x1 + 3*x2 + 7*x3 <= 83) # Total calcium constraint
m.addConstr(9*x0 + 7*x3 >= 8) # At least 8mg calcium from apple pies plus oreos
m.addConstr(6*x1 + 7*x3 >= 17) # At least 17mg calcium from green beans and oreos

# Additional constraints as per the problem description
m.addConstr(6*x1 - 5*x2 >= 0) # Six times the number of green beans minus five times granola bars is at minimum zero
m.addConstr(4*x2 + 4*x3 <= 20) # No more than 20mg iron from granola bars and oreos

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
