
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
apple_pies = m.addVar(lb=0, name="apple_pies")
green_beans = m.addVar(lb=0, name="green_beans")
granola_bars = m.addVar(lb=0, name="granola_bars")
oreos = m.addVar(lb=0, name="oreos")

# Define the objective function
m.setObjective(2 * apple_pies + 9 * green_beans + 2 * granola_bars + 4 * oreos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * apple_pies + 9 * green_beans + 4 * granola_bars + 4 * oreos <= 76)  # iron
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars + 6 * oreos <= 81)  # fat
m.addConstr(9 * apple_pies + 6 * green_beans + 3 * granola_bars + 7 * oreos <= 83)  # calcium

m.addConstr(4 * granola_bars + 4 * oreos >= 7)  # iron from granola bars and oreos
m.addConstr(9 * green_beans + 4 * granola_bars >= 6)  # iron from green beans and granola bars
m.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 14)  # fat from apple pies, granola bars, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 14)  # fat from apple pies, green beans, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 14)  # fat from apple pies, green beans, and granola bars
m.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 13)  # fat from apple pies, granola bars, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 13)  # fat from apple pies, green beans, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 13)  # fat from apple pies, green beans, and granola bars
m.addConstr(5 * apple_pies + 6 * granola_bars + 6 * oreos >= 11)  # fat from apple pies, granola bars, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * oreos >= 11)  # fat from apple pies, green beans, and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars >= 11)  # fat from apple pies, green beans, and granola bars

m.addConstr(9 * apple_pies + 7 * oreos >= 8)  # calcium from apple pies and oreos
m.addConstr(6 * green_beans + 7 * oreos >= 17)  # calcium from green beans and oreos
m.addConstr(6 * green_beans + 3 * granola_bars >= 10)  # calcium from green beans and granola bars
m.addConstr(9 * apple_pies + 3 * granola_bars >= 16)  # calcium from apple pies and granola bars

m.addConstr(6 * green_beans - 5 * granola_bars >= 0)

m.addConstr(4 * granola_bars + 4 * oreos <= 20)  # iron from granola bars and oreos
m.addConstr(5 * apple_pies + 9 * green_beans <= 36)  # iron from apple pies and green beans
m.addConstr(5 * apple_pies + 4 * oreos <= 63)  # iron from apple pies and oreos
m.addConstr(9 * green_beans + 4 * oreos <= 35)  # iron from green beans and oreos
m.addConstr(5 * apple_pies + 4 * granola_bars <= 57)  # iron from apple pies and granola bars
m.addConstr(5 * apple_pies + 4 * granola_bars + 4 * oreos <= 64)  # iron from apple pies, granola bars, and oreos
m.addConstr(5 * apple_pies + 9 * green_beans + 4 * granola_bars + 4 * oreos <= 64)

m.addConstr(6 * granola_bars + 6 * oreos <= 61)  # fat from granola bars and oreos
m.addConstr(4 * green_beans + 6 * oreos <= 65)  # fat from green beans and oreos
m.addConstr(5 * apple_pies + 6 * oreos <= 75)  # fat from apple pies and oreos
m.addConstr(5 * apple_pies + 4 * green_beans + 6 * granola_bars + 6 * oreos <= 75)

m.addConstr(9 * apple_pies + 3 * granola_bars <= 37)  # calcium from apple pies and granola bars
m.addConstr(3 * granola_bars + 7 * oreos <= 23)  # calcium from granola bars and oreos
m.addConstr(9 * apple_pies + 6 * green_beans <= 71)  # calcium from apple pies and green beans
m.addConstr(6 * green_beans + 7 * oreos <= 33)  # calcium from green beans and oreos
m.addConstr(6 * green_beans + 3 * granola_bars <= 78)  # calcium from green beans and granola bars
m.addConstr(9 * apple_pies + 6 * green_beans + 3 * granola_bars + 7 * oreos <= 78)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Apple Pies: ", apple_pies.varValue)
    print("Green Beans: ", green_beans.varValue)
    print("Granola Bars: ", granola_bars.varValue)
    print("Oreos: ", oreos.varValue)
else:
    print("The model is infeasible")
