
from gurobipy import *

# Create a model
m = Model("Military_Unit_Optimization")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="airborne_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="reconnaissance_troops")
x2 = m.addVar(vtype=GRB.INTEGER, name="medical_platoons")
x3 = m.addVar(vtype=GRB.INTEGER, name="military_intelligence_companies")

# Define the objective function
m.setObjective(8.45*x0 + 6.05*x1 + 1.68*x2 + 9.56*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.55*x0 + 1.03*x2 >= 19, name="logistics_footprint_airborne_medical_min")
m.addConstr(9.92*x1 + 8.91*x3 >= 14, name="logistics_footprint_reconnaissance_intelligence_min")
m.addConstr(9.92*x1 + 1.03*x2 >= 29, name="logistics_footprint_reconnaissance_medical_min")
m.addConstr(4.55*x0 + 8.91*x3 >= 22, name="logistics_footprint_airborne_intelligence_min")
m.addConstr(1.03*x2 + 8.91*x3 >= 25, name="logistics_footprint_medical_intelligence_min")
m.addConstr(9.92*x1 + 1.03*x2 + 8.91*x3 >= 32, name="logistics_footprint_reconnaissance_medical_intelligence_min")
m.addConstr(9.92*x1 + 1.03*x2 <= 71, name="logistics_footprint_reconnaissance_medical_max")
m.addConstr(4.55*x0 + 8.91*x3 <= 37, name="logistics_footprint_airborne_intelligence_max")
m.addConstr(1.03*x2 + 8.91*x3 <= 129, name="logistics_footprint_medical_intelligence_max")
m.addConstr(4.55*x0 + 1.03*x2 + 8.91*x3 <= 68, name="logistics_footprint_airborne_medical_intelligence_max")
m.addConstr(4.55*x0 + 9.92*x1 + 1.03*x2 + 8.91*x3 <= 135, name="total_logistics_footprint_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Airborne Infantry Companies: {x0.x}")
    print(f"Reconnaissance Troops: {x1.x}")
    print(f"Medical Platoons: {x2.x}")
    print(f"Military Intelligence Companies: {x3.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
