
from gurobipy import Model, GRB

# Create a new model
model = Model("Maximize Nutritional Value")

# Create variables
iron = model.addVar(lb=0, name="iron")  # milligrams of iron
b6 = model.addVar(lb=0, name="b6")  # milligrams of vitamin B6
fat = model.addVar(lb=0, name="fat")  # grams of fat

# Set objective function
model.setObjective(7.62 * iron + 3.72 * b6 + 1.4 * fat, GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * iron + 32 * fat <= 186, "c1")  # Combined cognitive performance index (iron + fat)
model.addConstr(24 * b6 + 32 * fat <= 218, "c2")  # Combined cognitive performance index (b6 + fat)
model.addConstr(15 * iron + 24 * b6 + 32 * fat <= 218, "c3")  # Combined cognitive performance index (iron + b6 + fat)
model.addConstr(-7 * iron + 2 * fat >= 0, "c4")  # Relationship between iron and fat


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Iron: {iron.x}")
    print(f"Vitamin B6: {b6.x}")
    print(f"Fat: {fat.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

