
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=0, name="milligrams_of_iron")
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B6")
x2 = m.addVar(lb=0, name="grams_of_fat")

# Set the objective function
m.setObjective(7.62*x0 + 3.72*x1 + 1.4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(-7*x0 + 2*x2 >= 0, name="constraint_1")
m.addConstr(15*x0 + 32*x2 <= 186, name="constraint_2")
m.addConstr(24*x1 + 32*x2 <= 218, name="constraint_3")
m.addConstr(15*x0 + 24*x1 + 32*x2 <= 218, name="constraint_4")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("milligrams_of_iron:", x0.x)
    print("milligrams_of_vitamin_B6:", x1.x)
    print("grams_of_fat:", x2.x)
else:
    print("No optimal solution found. Status:", m.status)

