
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="milligrams_of_iron", lb=0)
x1 = model.addVar(name="milligrams_of_vitamin_B6", lb=0)
x2 = model.addVar(name="grams_of_fat", lb=0)

# Define the objective function
model.setObjective(7.62 * x0 + 3.72 * x1 + 1.4 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(15 * x0 <= 229, name="cognitive_performance_index_iron")
model.addConstr(24 * x1 <= 229, name="cognitive_performance_index_vitamin_B6")
model.addConstr(32 * x2 <= 229, name="cognitive_performance_index_fat")

model.addConstr(-7 * x0 + 2 * x2 >= 0, name="iron_fat_constraint")

model.addConstr(15 * x0 + 32 * x2 <= 186, name="iron_fat_cognitive_performance")
model.addConstr(24 * x1 + 32 * x2 <= 218, name="vitamin_B6_fat_cognitive_performance")
model.addConstr(15 * x0 + 24 * x1 + 32 * x2 <= 218, name="total_cognitive_performance")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of iron: {x0.x}")
    print(f"Milligrams of vitamin B6: {x1.x}")
    print(f"Grams of fat: {x2.x}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
