
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
carrots = m.addVar(vtype=gp.GRB.INTEGER, name="carrots")
sunflowers = m.addVar(vtype=gp.GRB.INTEGER, name="sunflowers")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
carnations = m.addVar(vtype=gp.GRB.INTEGER, name="carnations")
potato_vines = m.addVar(vtype=gp.GRB.INTEGER, name="potato_vines")

# Set objective function
m.setObjective(5 * carrots + 9 * sunflowers + 8 * lilies + 5 * carnations + 7 * potato_vines, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * lilies + 1 * potato_vines >= 11, "c0")
m.addConstr(4 * sunflowers + 5 * lilies >= 15, "c1")
m.addConstr(2 * carnations + 1 * potato_vines >= 20, "c2")
m.addConstr(4 * sunflowers + 5 * lilies + 2 * carnations >= 12, "c3")
m.addConstr(7 * carrots + 2 * carnations + 1 * potato_vines >= 12, "c4")
m.addConstr(7 * carrots + 5 * lilies + 2 * carnations >= 12, "c5")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies >= 12, "c6")
m.addConstr(7 * carrots + 4 * sunflowers + 2 * carnations >= 12, "c7")
m.addConstr(4 * sunflowers + 5 * lilies + 2 * carnations >= 16, "c8")
m.addConstr(7 * carrots + 2 * carnations + 1 * potato_vines >= 16, "c9")
m.addConstr(7 * carrots + 5 * lilies + 2 * carnations >= 16, "c10")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies >= 16, "c11")
m.addConstr(7 * carrots + 4 * sunflowers + 2 * carnations >= 16, "c12")
m.addConstr(4 * sunflowers + 5 * lilies + 2 * carnations >= 16, "c13")
m.addConstr(7 * carrots + 2 * carnations + 1 * potato_vines >= 16, "c14")
m.addConstr(7 * carrots + 5 * lilies + 2 * carnations >= 16, "c15")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies >= 16, "c16")
m.addConstr(7 * carrots + 4 * sunflowers + 2 * carnations >= 16, "c17")
m.addConstr(4 * sunflowers + 5 * lilies + 2 * carnations >= 20, "c18")
m.addConstr(7 * carrots + 2 * carnations + 1 * potato_vines >= 20, "c19")
m.addConstr(7 * carrots + 5 * lilies + 2 * carnations >= 20, "c20")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies >= 20, "c21")
m.addConstr(7 * carrots + 4 * sunflowers + 2 * carnations >= 20, "c22")
m.addConstr(4 * sunflowers + 5 * lilies + 2 * carnations >= 19, "c23")
m.addConstr(7 * carrots + 2 * carnations + 1 * potato_vines >= 19, "c24")
m.addConstr(7 * carrots + 5 * lilies + 2 * carnations >= 19, "c25")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies >= 19, "c26")
m.addConstr(7 * carrots + 4 * sunflowers + 2 * carnations >= 19, "c27")


m.addConstr(7 * carrots + 5 * carnations >= 27, "c28")
m.addConstr(7 * carrots + 4 * potato_vines >= 18, "c29")
m.addConstr(5 * carnations + 4 * potato_vines >= 24, "c30")
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 29, "c31")
m.addConstr(1 * sunflowers + 8 * lilies + 5 * carnations >= 29, "c32")
m.addConstr(7 * carrots + 1 * sunflowers + 8 * lilies >= 29, "c33")
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 25, "c34")
m.addConstr(1 * sunflowers + 8 * lilies + 5 * carnations >= 25, "c35")
m.addConstr(7 * carrots + 1 * sunflowers + 8 * lilies >= 25, "c36")
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations >= 26, "c37")
m.addConstr(1 * sunflowers + 8 * lilies + 5 * carnations >= 26, "c38")
m.addConstr(7 * carrots + 1 * sunflowers + 8 * lilies >= 26, "c39")

m.addConstr(5 * lilies + 2 * carnations <= 70, "c40")
m.addConstr(4 * sunflowers + 2 * carnations <= 81, "c41")
m.addConstr(7 * carrots + 1 * potato_vines <= 95, "c42")
m.addConstr(5 * lilies + 1 * potato_vines <= 79, "c43")
m.addConstr(7 * carrots + 4 * sunflowers + 5 * lilies + 2 * carnations + 1 * potato_vines <= 79, "c44")
m.addConstr(7 * carrots + 1 * sunflowers <= 82, "c45")
m.addConstr(1 * sunflowers + 4 * potato_vines <= 56, "c46")
m.addConstr(1 * sunflowers + 5 * carnations <= 146, "c47")
m.addConstr(8 * lilies + 4 * potato_vines <= 129, "c48")
m.addConstr(1 * sunflowers + 8 * lilies + 5 * carnations <= 93, "c49")
m.addConstr(7 * carrots + 8 * lilies + 5 * carnations <= 114, "c50")
m.addConstr(7 * carrots + 8 * lilies + 4 * potato_vines <= 29, "c51") # Note: This constraint seems overly restrictive given others.
m.addConstr(8 * lilies + 5 * carnations + 4 * potato_vines <= 149, "c52")
m.addConstr(7 * carrots + 1 * sunflowers + 5 * carnations <= 98, "c53")
m.addConstr(7 * carrots + 1 * sunflowers + 8 * lilies <= 50, "c54")
m.addConstr(7 * carrots + 1 * sunflowers + 8 * lilies + 5 * carnations + 4 * potato_vines <= 50, "c55") # Note: This constraint seems overly restrictive given others.


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

