
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(lb=0, name="carbohydrates")
magnesium = m.addVar(lb=0, name="magnesium")
calcium = m.addVar(lb=0, name="calcium")
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")

# Set objective function
m.setObjective(2 * carbohydrates + 3 * magnesium + 3 * calcium + 4 * vitamin_b4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(carbohydrates + 7 * magnesium + 4 * calcium + 2 * vitamin_b4 <= 56, "muscle_growth_index_upper_bound")  # Resource r0 upper bound
m.addConstr(carbohydrates + 6 * magnesium + 4 * calcium + vitamin_b4 <= 61, "immune_support_index_upper_bound")  # Resource r1 upper bound

m.addConstr(carbohydrates + 7 * magnesium >= 10, "muscle_growth_index_carbohydrates_magnesium")
m.addConstr(carbohydrates + 2 * vitamin_b4 >= 8, "muscle_growth_index_carbohydrates_vitamin_b4")
m.addConstr(carbohydrates + 4 * calcium >= 5, "muscle_growth_index_carbohydrates_calcium")
m.addConstr(carbohydrates + 7 * magnesium + 4 * calcium + 2 * vitamin_b4 >= 5, "muscle_growth_index_total")

m.addConstr(carbohydrates + vitamin_b4 >= 7, "immune_support_index_carbohydrates_vitamin_b4")
m.addConstr(carbohydrates + 6 * magnesium >= 11, "immune_support_index_carbohydrates_magnesium")
m.addConstr(4 * calcium + vitamin_b4 >= 13, "immune_support_index_calcium_vitamin_b4")
m.addConstr(6 * magnesium + vitamin_b4 >= 7, "immune_support_index_magnesium_vitamin_b4")
m.addConstr(6 * magnesium + 4 * calcium + vitamin_b4 >= 13, "immune_support_index_magnesium_calcium_vitamin_b4")
m.addConstr(carbohydrates + 6 * magnesium + 4 * calcium + vitamin_b4 >= 13, "immune_support_index_total")

m.addConstr(7 * carbohydrates - 4 * calcium >= 0, "constraint_carbohydrates_calcium")
m.addConstr(-2 * magnesium + 2 * calcium >= 0, "constraint_magnesium_calcium")

m.addConstr(carbohydrates + 7 * magnesium + 2 * vitamin_b4 <= 46, "muscle_growth_index_carbohydrates_magnesium_vitamin_b4_upper_bound")
m.addConstr(carbohydrates + 4 * calcium + 2 * vitamin_b4 <= 29, "muscle_growth_index_carbohydrates_calcium_vitamin_b4_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

