
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
carbohydrates = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="carbohydrates")
magnesium = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="magnesium")
calcium = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="calcium")
vitamin_B4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B4")

# Objective function
model.setObjective(2 * carbohydrates + 3 * magnesium + 3 * calcium + 4 * vitamin_B4, gurobi.GRB.MINIMIZE)

# Constraints
# Muscle growth index constraints
model.addConstr(carbohydrates + 7 * magnesium >= 10, name="muscle_growth_1")
model.addConstr(carbohydrates + 2 * vitamin_B4 >= 8, name="muscle_growth_2")
model.addConstr(carbohydrates + 4 * calcium >= 5, name="muscle_growth_3")
model.addConstr(carbohydrates + 7 * magnesium + 4 * calcium + 2 * vitamin_B4 >= 5, name="muscle_growth_4")
model.addConstr(carbohydrates + 7 * magnesium + 2 * vitamin_B4 <= 46, name="muscle_growth_5")
model.addConstr(carbohydrates + 4 * calcium + 2 * vitamin_B4 <= 29, name="muscle_growth_6")

# Immune support index constraints
model.addConstr(carbohydrates + vitamin_B4 >= 7, name="immune_support_1")
model.addConstr(carbohydrates + 6 * magnesium >= 11, name="immune_support_2")
model.addConstr(4 * calcium + vitamin_B4 >= 13, name="immune_support_3")
model.addConstr(6 * magnesium + vitamin_B4 >= 7, name="immune_support_4")
model.addConstr(6 * magnesium + 4 * calcium + vitamin_B4 >= 13, name="immune_support_5")
model.addConstr(carbohydrates + 6 * magnesium + 4 * calcium + vitamin_B4 >= 13, name="immune_support_6")

# Additional constraints
model.addConstr(7 * carbohydrates - 4 * calcium >= 0, name="additional_1")
model.addConstr(-2 * magnesium + 2 * calcium >= 0, name="additional_2")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Carbohydrates: {carbohydrates.varValue}")
    print(f"Magnesium: {magnesium.varValue}")
    print(f"Calcium: {calcium.varValue}")
    print(f"Vitamin B4: {vitamin_B4.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
