
from gurobipy import Model, GRB

# Create a new model
model = Model("Optimization Problem")

# Create variables
oranges = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
fruit_salads = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
bowls_of_cereal = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Set objective function
model.setObjective(2 * oranges + 9 * fruit_salads + 9 * bowls_of_cereal, GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * oranges + 4 * bowls_of_cereal >= 26, "c0")
model.addConstr(oranges + 2 * bowls_of_cereal >= 13, "c1")
model.addConstr(oranges + 8 * fruit_salads + 2 * bowls_of_cereal >= 18, "c2")
model.addConstr(7 * fruit_salads + bowls_of_cereal >= 19, "c3")
model.addConstr(8 * oranges + bowls_of_cereal >= 11, "c4")
model.addConstr(4 * oranges + fruit_salads <= 54, "c5")
model.addConstr(4 * oranges + 4 * bowls_of_cereal <= 58, "c6")
model.addConstr(4 * oranges + fruit_salads + 4 * bowls_of_cereal <= 58, "c7")
model.addConstr(oranges + 8 * fruit_salads <= 62, "c8")
model.addConstr(oranges + 2 * bowls_of_cereal <= 49, "c9")
model.addConstr(oranges + 8 * fruit_salads + 2 * bowls_of_cereal <= 49, "c10")
model.addConstr(8 * oranges + 7 * fruit_salads <= 60, "c11")
model.addConstr(8 * oranges + bowls_of_cereal <= 34, "c12")
model.addConstr(7 * fruit_salads + bowls_of_cereal <= 39, "c13")
model.addConstr(8 * oranges + 7 * fruit_salads + bowls_of_cereal <= 39, "c14")
model.addConstr(2 * oranges + 8 * bowls_of_cereal <= 80, "c15")
model.addConstr(2 * oranges + 6 * fruit_salads + 8 * bowls_of_cereal <= 80, "c16")


# Resource Constraints
model.addConstr(4 * oranges + 1 * fruit_salads + 4 * bowls_of_cereal <= 84, "carbohydrates")
model.addConstr(1 * oranges + 8 * fruit_salads + 2 * bowls_of_cereal <= 65, "iron")
model.addConstr(8 * oranges + 7 * fruit_salads + 1 * bowls_of_cereal <= 68, "umami")
model.addConstr(2 * oranges + 6 * fruit_salads + 8 * bowls_of_cereal <= 85, "calcium")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('oranges:', oranges.x)
    print('fruit_salads:', fruit_salads.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

