
from gurobipy import *

# Create a model
m = Model("Nutrition_Optimization")

# Define variables
oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
fruit_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fruit_salads")
bowls_of_cereal = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Objective function: Maximize 2*oranges + 9*fruit_salads + 9*bowls_of_cereal
m.setObjective(2*oranges + 9*fruit_salads + 9*bowls_of_cereal, GRB.MAXIMIZE)

# Constraints
# At least 26 grams of carbohydrates from oranges and bowls of cereal
m.addConstr(4*oranges + 4*bowls_of_cereal >= 26, name="carbs_orange_cereal_min")

# At least 13 milligrams of iron from oranges plus bowls of cereal
m.addConstr(oranges + 2*bowls_of_cereal >= 13, name="iron_orange_cereal_min")

# At least 18 milligrams of iron from all sources
m.addConstr(oranges + 8*fruit_salads + 2*bowls_of_cereal >= 18, name="iron_all_min")

# Total umami index constraints
m.addConstr(7*fruit_salads + bowls_of_cereal >= 19, name="umami_fruit_cereal_min")
m.addConstr(8*oranges + bowls_of_cereal >= 11, name="umami_orange_cereal_min")

# Maximum carbohydrate constraints
m.addConstr(4*oranges + fruit_salads <= 54, name="carbs_orange_fruit_max")
m.addConstr(4*oranges + 4*bowls_of_cereal <= 58, name="carbs_orange_cereal_max")
m.addConstr(4*oranges + fruit_salads + 4*bowls_of_cereal <= 58, name="carbs_all_max")

# Maximum iron constraints
m.addConstr(oranges + 8*fruit_salads <= 62, name="iron_orange_fruit_max")
m.addConstr(oranges + 2*bowls_of_cereal <= 49, name="iron_orange_cereal_max")
m.addConstr(oranges + 8*fruit_salads + 2*bowls_of_cereal <= 49, name="iron_all_max")

# Maximum umami index constraints
m.addConstr(8*oranges + 7*fruit_salads <= 60, name="umami_orange_fruit_max")
m.addConstr(8*oranges + bowls_of_cereal <= 34, name="umami_orange_cereal_max")
m.addConstr(7*fruit_salads + bowls_of_cereal <= 39, name="umami_fruit_cereal_max")
m.addConstr(8*oranges + 7*fruit_salads + bowls_of_cereal <= 39, name="umami_all_max")

# Maximum calcium constraints
m.addConstr(2*oranges + 8*bowls_of_cereal <= 80, name="calcium_orange_cereal_max")
m.addConstr(2*oranges + 6*fruit_salads + 8*bowls_of_cereal <= 80, name="calcium_all_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oranges: {oranges.x}")
    print(f"Fruit Salads: {fruit_salads.x}")
    print(f"Bowls of Cereal: {bowls_of_cereal.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
