
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
oranges = m.addVar(lb=0, name="oranges")
fruit_salads = m.addVar(lb=0, name="fruit_salads")
bowls_of_cereal = m.addVar(lb=0, name="bowls_of_cereal")

# Define the objective function
m.setObjective(2 * oranges + 9 * fruit_salads + 9 * bowls_of_cereal, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(4 * oranges + 1 * fruit_salads + 4 * bowls_of_cereal <= 84)  # r0
m.addConstr(1 * oranges + 8 * fruit_salads + 2 * bowls_of_cereal <= 65)  # r1
m.addConstr(8 * oranges + 7 * fruit_salads + 1 * bowls_of_cereal <= 68)  # r2
m.addConstr(2 * oranges + 6 * fruit_salads + 8 * bowls_of_cereal <= 85)  # r3
m.addConstr(4 * oranges + 4 * bowls_of_cereal >= 26)
m.addConstr(1 * oranges + 2 * bowls_of_cereal >= 13)
m.addConstr(1 * oranges + 8 * fruit_salads + 2 * bowls_of_cereal >= 18)
m.addConstr(7 * fruit_salads + 1 * bowls_of_cereal >= 19)
m.addConstr(8 * oranges + 1 * bowls_of_cereal >= 11)
m.addConstr(4 * oranges + 1 * fruit_salads <= 54)
m.addConstr(4 * oranges + 4 * bowls_of_cereal <= 58)
m.addConstr(4 * oranges + 1 * fruit_salads + 4 * bowls_of_cereal <= 58)
m.addConstr(1 * oranges + 8 * fruit_salads <= 62)
m.addConstr(1 * oranges + 2 * bowls_of_cereal <= 49)
m.addConstr(1 * oranges + 8 * fruit_salads + 2 * bowls_of_cereal <= 49)
m.addConstr(8 * oranges + 7 * fruit_salads <= 60)
m.addConstr(8 * oranges + 1 * bowls_of_cereal <= 34)
m.addConstr(7 * fruit_salads + 1 * bowls_of_cereal <= 39)
m.addConstr(8 * oranges + 7 * fruit_salads + 1 * bowls_of_cereal <= 39)
m.addConstr(2 * oranges + 8 * bowls_of_cereal <= 80)
m.addConstr(2 * oranges + 6 * fruit_salads + 8 * bowls_of_cereal <= 80)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("oranges: ", oranges.varValue)
    print("fruit salads: ", fruit_salads.varValue)
    print("bowls of cereal: ", bowls_of_cereal.varValue)
else:
    print("The model is infeasible")
