
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")

# Set objective function
m.setObjective(4.5 * jean_hours + 9.58 * dale_hours + 5.64 * paul_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6 * dale_hours + 10 * paul_hours >= 32, "c0")
m.addConstr(16 * jean_hours + 6 * dale_hours >= 54, "c1")
m.addConstr(16 * jean_hours + 6 * dale_hours + 10 * paul_hours >= 54, "c2")
m.addConstr(23 * dale_hours + 20 * paul_hours >= 41, "c3")
m.addConstr(12 * jean_hours + 23 * dale_hours + 20 * paul_hours >= 41, "c4")
m.addConstr(6 * dale_hours - 7 * paul_hours >= 0, "c5")
m.addConstr(6 * jean_hours - 5 * paul_hours >= 0, "c6")
m.addConstr(6 * dale_hours + 10 * paul_hours <= 169, "c7")
m.addConstr(16 * jean_hours + 10 * paul_hours <= 148, "c8")
m.addConstr(12 * jean_hours + 23 * dale_hours <= 116, "c9")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Jean hours:', jean_hours.x)
    print('Dale hours:', dale_hours.x)
    print('Paul hours:', paul_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

