
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
J = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
D = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
P = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")

# Objective function
m.setObjective(4.5*J + 9.58*D + 5.64*P, GRB.MINIMIZE)

# Constraints
m.addConstr(6*D + 10*P >= 32, "min_cost_dale_paul")
m.addConstr(16*J + 6*D >= 54, "min_cost_jean_dale")
m.addConstr(16*J + 6*D + 10*P >= 54, "min_cost_all")
m.addConstr(23*D + 20*P >= 41, "min_productivity_dale_paul")
m.addConstr(12*J + 23*D + 20*P >= 41, "min_productivity_all")
m.addConstr(6*D - 7*P >= 0, "additional_constraint_1")
m.addConstr(6*J - 5*P >= 0, "additional_constraint_2")
m.addConstr(6*D + 10*P <= 169, "max_cost_dale_paul")
m.addConstr(16*J + 10*P <= 148, "max_cost_jean_paul")
m.addConstr(12*J + 23*D <= 116, "max_productivity_jean_dale")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Jean: {J.x}")
    print(f"Hours worked by Dale: {D.x}")
    print(f"Hours worked by Paul: {P.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
