
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    J = model.addVar(name="hours_worked_by_Jean", lb=0)
    D = model.addVar(name="hours_worked_by_Dale", lb=0)
    P = model.addVar(name="hours_worked_by_Paul", lb=0)

    # Define the objective function
    model.setObjective(4.5 * J + 9.58 * D + 5.64 * P, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * D + 10 * P >= 32, name="min_dollar_cost_D_P")
    model.addConstr(16 * J + 6 * D >= 54, name="min_dollar_cost_J_D")
    model.addConstr(16 * J + 6 * D + 10 * P >= 54, name="min_dollar_cost_J_D_P")
    model.addConstr(23 * D + 20 * P >= 41, name="min_productivity_D_P")
    model.addConstr(12 * J + 23 * D + 20 * P >= 41, name="min_productivity_J_D_P")
    model.addConstr(6 * D - 7 * P >= 0, name="D_P_constraint")
    model.addConstr(6 * J - 5 * P >= 0, name="J_P_constraint")
    model.addConstr(6 * D + 10 * P <= 169, name="max_dollar_cost_D_P")
    model.addConstr(16 * J + 10 * P <= 148, name="max_dollar_cost_J_P")
    model.addConstr(12 * J + 23 * D <= 116, name="max_productivity_J_D")

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Jean: {J.varValue}")
        print(f"Hours worked by Dale: {D.varValue}")
        print(f"Hours worked by Paul: {P.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
