
from gurobipy import Model, GRB

# Create a new model
model = Model("knishes_kiwis")

# Create variables
knishes = model.addVar(vtype=GRB.INTEGER, name="knishes")
kiwis = model.addVar(vtype=GRB.CONTINUOUS, name="kiwis")

# Set objective function
model.setObjective(4 * knishes + 8 * kiwis, GRB.MAXIMIZE)

# Add constraints
model.addConstr(22 * knishes + 28 * kiwis >= 21, "carbohydrates_min")
model.addConstr(14 * knishes + 10 * kiwis >= 40, "calcium_min")
model.addConstr(9 * knishes - 3 * kiwis >= 0, "knishes_kiwis_ratio")

# Redundant/Conflicting constraints - choosing the most restrictive
model.addConstr(22 * knishes + 28 * kiwis <= 49, "carbohydrates_max") # Most restrictive carbohydrate constraint
model.addConstr(14 * knishes + 10 * kiwis <= 77, "calcium_max") # Most restrictive calcium constraint


# Resource Constraints (given in the problem context)
model.addConstr(22 * knishes + 28 * kiwis <= 93, "carbohydrates_resource_limit")
model.addConstr(14 * knishes + 10 * kiwis <= 94, "calcium_resource_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Number of knishes: {knishes.x}")
    print(f"Number of kiwis: {kiwis.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

