
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
K = m.addVar(vtype=GRB.INTEGER, name="knishes")  # Number of knishes (integer)
W = m.addVar(vtype=GRB.CONTINUOUS, name="kiwis")  # Number of kiwis (can be non-integer)

# Objective function: Maximize
m.setObjective(4*K + 8*W, GRB.MAXIMIZE)

# Constraints
m.addConstr(22*K + 28*W >= 21, "min_carbohydrates")
m.addConstr(22*K + 28*W <= 49, "max_carbohydrates")
m.addConstr(14*K + 10*W >= 40, "min_calcium")
m.addConstr(14*K + 10*W <= 77, "max_calcium")
m.addConstr(9*K - 3*W >= 0, "linear_combination")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: K={K.x}, W={W.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
