
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    knishes = model.addVar(vtype=gurobi.GRB.INTEGER, name="knishes", lb=0)
    kiwis = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="kiwis", lb=0)

    # Objective function: Maximize 4 * knishes + 8 * kiwis
    model.setObjective(4 * knishes + 8 * kiwis, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(22 * knishes + 28 * kiwis >= 21, name="carbohydrates_min")
    model.addConstr(14 * knishes + 10 * kiwis >= 40, name="calcium_min")
    model.addConstr(9 * knishes - 3 * kiwis >= 0, name="knishes_kiwis_ratio")
    model.addConstr(22 * knishes + 28 * kiwis <= 49, name="carbohydrates_max49")
    model.addConstr(14 * knishes + 10 * kiwis <= 77, name="calcium_max77")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Knishes: {knishes.varValue}, Kiwis: {kiwis.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
