
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
iron = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
potassium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
vitamin_e = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_e")

# Set objective function
model.setObjective(6.91 * iron**2 + 9.46 * iron * potassium + 8.04 * vitamin_e**2 + 1.53 * potassium + 2.22 * vitamin_e, GRB.MINIMIZE)

# Add constraints
model.addConstr(9 * iron**2 + 7 * vitamin_e**2 >= 11, "c1")
model.addConstr(1 * potassium**2 + 7 * vitamin_e**2 >= 25, "c2")
model.addConstr(9 * iron**2 + 1 * potassium**2 + 7 * vitamin_e**2 >= 18, "c3")
model.addConstr(9 * iron + 1 * potassium + 7 * vitamin_e >= 18, "c4")
model.addConstr(11 * iron**2 + 9 * potassium**2 >= 16, "c5")
model.addConstr(11 * iron**2 + 11 * vitamin_e**2 >= 23, "c6")
model.addConstr(9 * potassium**2 + 11 * vitamin_e**2 >= 10, "c7")
model.addConstr(11 * iron + 9 * potassium + 11 * vitamin_e >= 18, "c8")
model.addConstr(-9 * potassium + 7 * vitamin_e >= 0, "c9")
model.addConstr(2 * iron**2 - 4 * potassium**2 >= 0, "c10")
model.addConstr(9 * iron + 1 * potassium <= 44, "c11")
model.addConstr(1 * potassium**2 + 7 * vitamin_e**2 <= 66, "c12")
model.addConstr(9 * potassium + 11 * vitamin_e <= 44, "c13")
model.addConstr(11 * iron + 11 * vitamin_e <= 35, "c14")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('iron:', iron.x)
    print('potassium:', potassium.x)
    print('vitamin_e:', vitamin_e.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)

