
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_B = model.addVar(name="hours_worked_by_Bill", lb=0)
    x_H = model.addVar(name="hours_worked_by_Hank", lb=0)
    x_Bo = model.addVar(name="hours_worked_by_Bobby", lb=0)
    x_J = model.addVar(name="hours_worked_by_John", lb=0)

    # Define the objective function
    model.setObjective(9 * x_B + 3 * x_H + 2 * x_Bo + 2 * x_J, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(6 * x_B >= 31)
    model.addConstr(6 * x_B + 7 * x_Bo >= 31)
    model.addConstr(6 * x_B + 6 * x_H + 11 * x_J >= 37)
    model.addConstr(6 * x_B + 6 * x_H + 7 * x_Bo >= 37)
    model.addConstr(9 * x_H + 18 * x_Bo >= 17)
    model.addConstr(9 * x_H + 12 * x_J >= 20)
    model.addConstr(8 * x_B + 9 * x_H >= 27)
    model.addConstr(18 * x_Bo + 12 * x_J >= 19)
    model.addConstr(7 * x_B + x_Bo + 13 * x_J >= 26)
    model.addConstr(7 * x_B + 4 * x_H + x_Bo >= 26)
    model.addConstr(7 * x_B + x_Bo + 13 * x_J >= 27)
    model.addConstr(7 * x_B + 4 * x_H + x_Bo >= 27)
    model.addConstr(7 * x_Bo + 11 * x_J <= 99)
    model.addConstr(6 * x_B + 11 * x_J <= 52)
    model.addConstr(6 * x_B + 7 * x_Bo <= 118)
    model.addConstr(6 * x_B + 7 * x_Bo + 11 * x_J <= 60)
    model.addConstr(6 * x_B + 6 * x_H + 7 * x_Bo + 11 * x_J <= 60)
    model.addConstr(8 * x_B + 18 * x_Bo <= 104)
    model.addConstr(9 * x_H + 18 * x_Bo <= 63)
    model.addConstr(8 * x_B + 12 * x_J <= 34)
    model.addConstr(8 * x_B + 9 * x_H <= 72)
    model.addConstr(8 * x_B + 9 * x_H + 18 * x_Bo + 12 * x_J <= 72)
    model.addConstr(7 * x_B + 4 * x_H <= 64)
    model.addConstr(7 * x_B + x_Bo <= 71)
    model.addConstr(7 * x_B + 13 * x_J <= 106)
    model.addConstr(4 * x_H + 13 * x_J <= 29)
    model.addConstr(7 * x_B + 4 * x_H + x_Bo + 13 * x_J <= 29)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x_B.varValue}")
        print(f"Hours worked by Hank: {x_H.varValue}")
        print(f"Hours worked by Bobby: {x_Bo.varValue}")
        print(f"Hours worked by John: {x_J.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
