
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ham_sandwiches")  # Continuous
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="blueberry_pies")  # Integer

# Set objective function
m.setObjective(3.97 * x0 + 1.71 * x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.09 * x0 + 3.56 * x1 >= 79, "carbohydrates_min")
m.addConstr(3.68 * x0 + 0.65 * x1 >= 73, "fat_min")
m.addConstr(5.03 * x0 + 5.33 * x1 >= 57, "tastiness_min")
m.addConstr(-8 * x0 + 7 * x1 >= 0, "sandwich_pie_relation")

m.addConstr(4.09 * x0 + 3.56 * x1 <= 227, "carbohydrates_max1") # Redundant with next constraint
m.addConstr(4.09 * x0 + 3.56 * x1 <= 227, "carbohydrates_max2")
m.addConstr(3.68 * x0 + 0.65 * x1 <= 120, "fat_max1") # Redundant with next constraint
m.addConstr(3.68 * x0 + 0.65 * x1 <= 120, "fat_max2")
m.addConstr(5.03 * x0 + 5.33 * x1 <= 173, "tastiness_max1") # Redundant with next constraint
m.addConstr(5.03 * x0 + 5.33 * x1 <= 173, "tastiness_max2")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ham sandwiches:', x0.x)
    print('blueberry pies:', x1.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

