
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define variables
ham_sandwiches = model.addVar(lb=0, ub=None, name="ham_sandwiches", vtype=gurobi.GRB.CONTINUOUS)
blueberry_pies = model.addVar(lb=0, ub=None, name="blueberry_pies", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(3.97 * ham_sandwiches + 1.71 * blueberry_pies, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(4.09 * ham_sandwiches + 3.56 * blueberry_pies >= 79, name="carbohydrates_min")
model.addConstr(4.09 * ham_sandwiches + 3.56 * blueberry_pies <= 227, name="carbohydrates_max") # Using 227 as it was repeated

model.addConstr(3.68 * ham_sandwiches + 0.65 * blueberry_pies >= 73, name="fat_min")
model.addConstr(3.68 * ham_sandwiches + 0.65 * blueberry_pies <= 120, name="fat_max")

model.addConstr(5.03 * ham_sandwiches + 5.33 * blueberry_pies >= 57, name="tastiness_min")
model.addConstr(5.03 * ham_sandwiches + 5.33 * blueberry_pies <= 173, name="tastiness_max")

model.addConstr(-8 * ham_sandwiches + 7 * blueberry_pies >= 0, name="linear_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ham sandwiches: {ham_sandwiches.varValue}")
    print(f"Blueberry pies: {blueberry_pies.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
